#! /usr/bin/perl -w

use strict;
use warnings FATAL => qw( all );

use JSON;
use Data::Dumper;

# configure the OVMS server
my $server = 'https://tmc.openvehicles.com:6869';

# configure for your account and vehicle
my $username = 'your_ovms_username';
my $password = 'your_ovms_password';
my $vehicle = 'your_vehicle_identifier';

# where the log records get accumulated
my $filenameVehicleLogs = 'ovms-vehicle-logs.txt';
my $filenameServerLogs = 'ovms-server-logs.txt';

my $filenameCookieJar = 'ovms-cookie';

my %mp_mode_name = 
(
	0 => 'Standard',
	1 => 'Storage',
	3 => 'Range',
	4 => 'Performance'
);

sub FOVMSLogin($$$);
sub OVMSLogout($);
sub DoOVMSCommand($$$);

sub LocalDateString(;$);

my $reply;
my $cmd;
my $blob;

if (!FOVMSLogin($filenameCookieJar, $username, $password))
{
	die 'ERROR: login failed';
}

print "LOGIN succeeded\n";
print "\n";

# do the vehicle logs (drive and charge log records)
{
	my %mp_date_entry = ();

	if (1)
	{
		# get the historical drive records
		$reply = DoOVMSCommand($filenameCookieJar, 'GET', 'historical/' . $vehicle . '/*-Log-Drive');

		# decode the reply
		$blob = decode_json($reply);

		# dump out everything in the reply
#		print Dumper($blob);
#		print "\n";
	
		foreach my $rec (@{$blob})
		{
			my $entry = ();

			$entry->{'h_timestamp'} = $rec->{'h_timestamp'};
			$entry->{'h_data'} = $rec->{'h_data'};
			$entry->{'type'} = 'D';
			$mp_date_entry{$entry->{'h_timestamp'}} = $entry;
		}
	}

	if (1)
	{
		# get the historical charge records
		$reply = DoOVMSCommand($filenameCookieJar, 'GET', 'historical/' . $vehicle . '/*-Log-Charge');

		# decode the reply
		$blob = decode_json($reply);

		# dump out everything in the reply
	#	print Dumper($blob);
	#	print "\n";
	
		foreach my $rec (@{$blob})
		{
			my $entry = ();

			$entry->{'h_timestamp'} = $rec->{'h_timestamp'};
			$entry->{'h_data'} = $rec->{'h_data'};
			$entry->{'type'} = 'C';
			$mp_date_entry{$entry->{'h_timestamp'}} = $entry;
		}
	}

	# scan the vehicle archive file for existing records
	my $dateLast = '';
	open(my $file, '<', $filenameVehicleLogs) or die "can't open $filenameVehicleLogs: $!";
	while (<$file>)
	{
		my @afield = split("\t");
	
		$dateLast = $afield[0];
	}
	close($file);

	print "Vehicle Logs:\n";
	print "dateLast = $dateLast\n";

	my $crecAdded = 0;
	my $dateNew = $dateLast;
	open($file, '>>', $filenameVehicleLogs) or die "can't open $filenameVehicleLogs: $!";
	foreach my $date (sort keys %mp_date_entry)
	{
		next if ($dateLast ne '' && $date le $dateLast);

		my $entry = $mp_date_entry{$date};

		my $strLog = join("\t", $entry->{'h_timestamp'}, $entry->{'type'}, $entry->{'h_data'});
		print $strLog , "\n";
		print $file $strLog , "\n";
		++$crecAdded;
		$dateNew = $date;
	}
	close($file);
	print "$crecAdded record(s) added to $filenameVehicleLogs, last record at $dateNew\n";
	print "\n";
}

# do the server logs with the detailed records
{
	my $dateLast = '';
	my %dnrecLast = ();
	open(my $file, '<', $filenameServerLogs) or die "can't open $filenameServerLogs: $!";
	while (<$file>)
	{
		chomp;
		my ($date, $recordnumber, $value) = split("\t");

		next unless $date && $recordnumber && $value;
		my $key = join('-', $date, $recordnumber);
		if ($dnrecLast{$key})
		{
#			print "duplicate record ID $key: $dnrecLast{$key} and $value\n";
		}
#		print "$key -> $value\n";
		$dnrecLast{$key} = $value;
		$dateLast = $date;
	}
	close($file);

	print "Server Logs:\n";
	print "dateLast = $dateLast\n";

	if (1)
	{
		print "Server Logs:\n";
		print "\n";

		# get the recent server log records
		$reply = DoOVMSCommand($filenameCookieJar, 'GET', 'historical/' . $vehicle . '/*-OVM-ServerLogs');

		# decode the reply
		$blob = decode_json($reply);

		# dump out everything in the reply
	#	print Dumper($blob);
	#	print "\n";
	
		my $crecAdded = 0;
		my $dateNew = $dateLast;
		open($file, '>>', $filenameServerLogs) or die "can't open $filenameServerLogs: $!";

		foreach my $rec (@{$blob})
		{
			my $key = join('-', $rec->{'h_timestamp'}, $rec->{'h_recordnumber'});
			if ($dnrecLast{$key})
			{
#				print "skip duplicate entry $rec->{'h_timestamp'}\t$rec->{'h_recordnumber'}\t$rec->{'h_data'}\n";
				next;
			}

			my $strLog = join("\t", $rec->{'h_timestamp'}, $rec->{'h_recordnumber'}, $rec->{'h_data'});
			print $strLog , "\n";
			print $file $strLog , "\n";
			++$crecAdded;
			$dateNew = $rec->{'h_timestamp'};
		}

		close($file);
		print "$crecAdded record(s) added to $filenameServerLogs, last record at $dateNew\n";
		print "\n";
	}
}

$reply = OVMSLogout($filenameCookieJar);

print $reply, "\n";

sub FOVMSLogin($$$)
{
	my ($cookiejar, $username, $password) = @_;

	$cmd = "curl -s -X GET -c $cookiejar \"$server/api/cookie?username=$username\&password=$password\"";
#	print $cmd, "\n";
	$reply = `$cmd`;
	
	return $reply =~ /login ok/i;
}

sub OVMSLogout($)
{
	my ($cookiejar) = @_;

	return DoOVMSCommand($cookiejar, 'DELETE', 'cookie');
}

sub DoOVMSCommand($$$)
{
	my ($cookiejar, $verb, $command) = @_;
	
	$cmd = "curl -s -X $verb -b $cookiejar $server/api/$command";
#	print $cmd, "\n";
	$reply = `$cmd`;
	
	return $reply;
}

sub LocalDateString(;$)
{
	my ($time) = @_;
	
	if (! $time)
	{
		$time = time();
	}
	my ($sec, $min, $hour, $mday, $mon, $year) = localtime($time);
	return sprintf("%02d/%02d/%04d-%02d:%02d:%02d", $mon + 1, $mday, $year + 1900, $hour, $min, $sec);
}
